#ifndef _GFX_H_
#define _GFX_H_

#include <allegro.h>

#define GFX_NONE          (0)
#define GFX_DOUBLE_BUFFER (1)
#define GFX_PAGE_FLIP     (2)

extern char *gfx_name[];

typedef struct GFX_OVERLAY
{
	BITMAP *bmp;
	int x, y;
	int draw_mode;

	struct GFX_OVERLAY *next;
} GFX_OVERLAY;

typedef struct GFX
{
	BITMAP **pages;
	BITMAP *buffer;
	int num_pages;
	int type;
	int current_page;

	GFX_OVERLAY *overlays;
} GFX;

GFX *gfx_create(int type);
GFX *gfx_create_ex(int type, int width, int height, int color_depth);
void gfx_destroy(GFX *gfx);
BITMAP *gfx_frame_start (GFX *gfx);
void gfx_frame_end (GFX *gfx);
void gfx_switch_type (GFX **gfx, int type);
GFX_OVERLAY *gfx_add_overlay(GFX *gfx, BITMAP *bmp, int x, int y, int draw_mode);
void gfx_remove_overlay(GFX *gfx, GFX_OVERLAY *overlay);

#endif
